package jp.ac.keio.bio.fun.valvecontroller;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ValveCofiguratorGUI extends JFrame{
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  private JFrame main_frame = this;

  private JTextArea portA_valve1_ta = null;
  private JTextArea portA_valve2_ta = null;
  private JTextArea portA_valve3_ta = null;
  private JTextArea portA_valve4_ta = null;
  private JTextArea portA_valve5_ta = null;
  private JTextArea portA_valve6_ta = null;
  private JTextArea portA_valve7_ta = null;
  private JTextArea portA_valve8_ta = null;

  private JTextArea portB_valve1_ta = null;
  private JTextArea portB_valve2_ta = null;
  private JTextArea portB_valve3_ta = null;
  private JTextArea portB_valve4_ta = null;
  private JTextArea portB_valve5_ta = null;
  private JTextArea portB_valve6_ta = null;
  private JTextArea portB_valve7_ta = null;
  private JTextArea portB_valve8_ta = null;

  private JTextArea portC_valve1_ta = null;
  private JTextArea portC_valve2_ta = null;
  private JTextArea portC_valve3_ta = null;
  private JTextArea portC_valve4_ta = null;
  private JTextArea portC_valve5_ta = null;
  private JTextArea portC_valve6_ta = null;
  private JTextArea portC_valve7_ta = null;
  private JTextArea portC_valve8_ta = null;

  private JRadioButton portA_valve1_radio = null;
  private JRadioButton portA_valve2_radio = null;
  private JRadioButton portA_valve3_radio = null;
  private JRadioButton portA_valve4_radio = null;
  private JRadioButton portA_valve5_radio = null;
  private JRadioButton portA_valve6_radio = null;
  private JRadioButton portA_valve7_radio = null;
  private JRadioButton portA_valve8_radio = null;

  private JRadioButton portB_valve1_radio = null;
  private JRadioButton portB_valve2_radio = null;
  private JRadioButton portB_valve3_radio = null;
  private JRadioButton portB_valve4_radio = null;
  private JRadioButton portB_valve5_radio = null;
  private JRadioButton portB_valve6_radio = null;
  private JRadioButton portB_valve7_radio = null;
  private JRadioButton portB_valve8_radio = null;

  private JRadioButton portC_valve1_radio = null;
  private JRadioButton portC_valve2_radio = null;
  private JRadioButton portC_valve3_radio = null;
  private JRadioButton portC_valve4_radio = null;
  private JRadioButton portC_valve5_radio = null;
  private JRadioButton portC_valve6_radio = null;
  private JRadioButton portC_valve7_radio = null;
  private JRadioButton portC_valve8_radio = null;

  private JButton finish_button = null;
  private JButton all_clear_button = null;
  private JButton initialize_button = null;
  private JButton visualize_button = null;

  private ArrayList<JTextArea> valve_ta_list = null;
  private ArrayList<JRadioButton> valve_radio_list = null;
  private ArrayList<JTextArea> valve_ta_list_init = null;
  private ArrayList<JRadioButton> valve_radio_list_init = null;

  private JTabbedPane port_tabs = null;
  private JPanel portA_tab = null;
  private JPanel portB_tab = null;
  private JPanel portC_tab = null;

  private JTextField controlling_time_fieldA = null;
  private JTextField controlling_time_fieldB = null;
  private JTextField controlling_time_fieldC = null;
  private JTextField controlling_time_field_init = null;

  private ArrayList<visualizeFrame> sub_frame_list = null;

  private String current_dir;
  // private String parent_dir;
  private String config_dir;

  ValveCofiguratorGUI(){
    super("Valve Control Pattern");
    current_dir = new File(".").getAbsoluteFile().getParent();
    // config_dir = current_dir + "/valve_controller_program/myControlProg/";
    config_dir = current_dir + "/myControlProg/";
    // parent_dir = new File(".").getAbsoluteFile().getParentFile().getParent();
    System.out.println(current_dir);
    // System.out.println(parent_dir);
    this.setSize(1000, 340);
    this.setResizable(false);
    this.setDefaultCloseOperation(EXIT_ON_CLOSE);
    this.setContentPane(new myContentPane());
    this.setVisible(true);
  }

  public static void main(String args[]){
    new ValveCofiguratorGUI();
  }


  private class myContentPane extends JPanel{
    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    myContentPane(){
      super();
      this.setLayout(new BorderLayout());

      sub_frame_list = new ArrayList<visualizeFrame>();

      port_tabs = new JTabbedPane();
      port_tabs.setTabPlacement(JTabbedPane.TOP);
      portA_tab = new JPanel();
      portA_tab.setLayout(null);
      portB_tab = new JPanel();
      portB_tab.setLayout(null);
      portC_tab = new JPanel();
      portC_tab.setLayout(null);
      port_tabs.addTab("port A", portA_tab);
      port_tabs.addTab("port B", portB_tab);
      port_tabs.addTab("port C", portC_tab);
      this.add(port_tabs, BorderLayout.CENTER);

      valve_ta_list = new ArrayList<JTextArea>();

      portA_valve1_ta = new JTextArea();
      portA_valve2_ta = new JTextArea();
      portA_valve3_ta = new JTextArea();
      portA_valve4_ta = new JTextArea();
      portA_valve5_ta = new JTextArea();
      portA_valve6_ta = new JTextArea();
      portA_valve7_ta = new JTextArea();
      portA_valve8_ta = new JTextArea();

      portB_valve1_ta = new JTextArea();
      portB_valve2_ta = new JTextArea();
      portB_valve3_ta = new JTextArea();
      portB_valve4_ta = new JTextArea();
      portB_valve5_ta = new JTextArea();
      portB_valve6_ta = new JTextArea();
      portB_valve7_ta = new JTextArea();
      portB_valve8_ta = new JTextArea();

      portC_valve1_ta = new JTextArea();
      portC_valve2_ta = new JTextArea();
      portC_valve3_ta = new JTextArea();
      portC_valve4_ta = new JTextArea();
      portC_valve5_ta = new JTextArea();
      portC_valve6_ta = new JTextArea();
      portC_valve7_ta = new JTextArea();
      portC_valve8_ta = new JTextArea();

      valve_ta_list.add(portA_valve1_ta);
      valve_ta_list.add(portA_valve2_ta);
      valve_ta_list.add(portA_valve3_ta);
      valve_ta_list.add(portA_valve4_ta);
      valve_ta_list.add(portA_valve5_ta);
      valve_ta_list.add(portA_valve6_ta);
      valve_ta_list.add(portA_valve7_ta);
      valve_ta_list.add(portA_valve8_ta);
      valve_ta_list.add(portB_valve1_ta);
      valve_ta_list.add(portB_valve2_ta);
      valve_ta_list.add(portB_valve3_ta);
      valve_ta_list.add(portB_valve4_ta);
      valve_ta_list.add(portB_valve5_ta);
      valve_ta_list.add(portB_valve6_ta);
      valve_ta_list.add(portB_valve7_ta);
      valve_ta_list.add(portB_valve8_ta);
      valve_ta_list.add(portC_valve1_ta);
      valve_ta_list.add(portC_valve2_ta);
      valve_ta_list.add(portC_valve3_ta);
      valve_ta_list.add(portC_valve4_ta);
      valve_ta_list.add(portC_valve5_ta);
      valve_ta_list.add(portC_valve6_ta);
      valve_ta_list.add(portC_valve7_ta);
      valve_ta_list.add(portC_valve8_ta);


      for(int i=0; i<valve_ta_list.size(); i++){
        valve_ta_list.get(i).setEditable(true);
        valve_ta_list.get(i).setLineWrap(true);
        valve_ta_list.get(i).addMouseListener(new rewriteControllingTime());
        valve_ta_list.get(i).addKeyListener(new repaintByTextArea());
      }

      ArrayList<JScrollPane> scroll_list = new ArrayList<JScrollPane>();

      JScrollPane portA_valve1_scroll = new JScrollPane(portA_valve1_ta);
      JScrollPane portA_valve2_scroll = new JScrollPane(portA_valve2_ta);
      JScrollPane portA_valve3_scroll = new JScrollPane(portA_valve3_ta);
      JScrollPane portA_valve4_scroll = new JScrollPane(portA_valve4_ta);
      JScrollPane portA_valve5_scroll = new JScrollPane(portA_valve5_ta);
      JScrollPane portA_valve6_scroll = new JScrollPane(portA_valve6_ta);
      JScrollPane portA_valve7_scroll = new JScrollPane(portA_valve7_ta);
      JScrollPane portA_valve8_scroll = new JScrollPane(portA_valve8_ta);

      JScrollPane portB_valve1_scroll = new JScrollPane(portB_valve1_ta);
      JScrollPane portB_valve2_scroll = new JScrollPane(portB_valve2_ta);
      JScrollPane portB_valve3_scroll = new JScrollPane(portB_valve3_ta);
      JScrollPane portB_valve4_scroll = new JScrollPane(portB_valve4_ta);
      JScrollPane portB_valve5_scroll = new JScrollPane(portB_valve5_ta);
      JScrollPane portB_valve6_scroll = new JScrollPane(portB_valve6_ta);
      JScrollPane portB_valve7_scroll = new JScrollPane(portB_valve7_ta);
      JScrollPane portB_valve8_scroll = new JScrollPane(portB_valve8_ta);

      JScrollPane portC_valve1_scroll = new JScrollPane(portC_valve1_ta);
      JScrollPane portC_valve2_scroll = new JScrollPane(portC_valve2_ta);
      JScrollPane portC_valve3_scroll = new JScrollPane(portC_valve3_ta);
      JScrollPane portC_valve4_scroll = new JScrollPane(portC_valve4_ta);
      JScrollPane portC_valve5_scroll = new JScrollPane(portC_valve5_ta);
      JScrollPane portC_valve6_scroll = new JScrollPane(portC_valve6_ta);
      JScrollPane portC_valve7_scroll = new JScrollPane(portC_valve7_ta);
      JScrollPane portC_valve8_scroll = new JScrollPane(portC_valve8_ta);

      scroll_list.add(portA_valve1_scroll);
      scroll_list.add(portA_valve2_scroll);
      scroll_list.add(portA_valve3_scroll);
      scroll_list.add(portA_valve4_scroll);
      scroll_list.add(portA_valve5_scroll);
      scroll_list.add(portA_valve6_scroll);
      scroll_list.add(portA_valve7_scroll);
      scroll_list.add(portA_valve8_scroll);

      scroll_list.add(portB_valve1_scroll);
      scroll_list.add(portB_valve2_scroll);
      scroll_list.add(portB_valve3_scroll);
      scroll_list.add(portB_valve4_scroll);
      scroll_list.add(portB_valve5_scroll);
      scroll_list.add(portB_valve6_scroll);
      scroll_list.add(portB_valve7_scroll);
      scroll_list.add(portB_valve8_scroll);

      scroll_list.add(portC_valve1_scroll);
      scroll_list.add(portC_valve2_scroll);
      scroll_list.add(portC_valve3_scroll);
      scroll_list.add(portC_valve4_scroll);
      scroll_list.add(portC_valve5_scroll);
      scroll_list.add(portC_valve6_scroll);
      scroll_list.add(portC_valve7_scroll);
      scroll_list.add(portC_valve8_scroll);

      valve_radio_list = new ArrayList<JRadioButton>();

      portA_valve1_radio = new JRadioButton();
      portA_valve2_radio = new JRadioButton();
      portA_valve3_radio = new JRadioButton();
      portA_valve4_radio = new JRadioButton();
      portA_valve5_radio = new JRadioButton();
      portA_valve6_radio = new JRadioButton();
      portA_valve7_radio = new JRadioButton();
      portA_valve8_radio = new JRadioButton();

      portB_valve1_radio = new JRadioButton();
      portB_valve2_radio = new JRadioButton();
      portB_valve3_radio = new JRadioButton();
      portB_valve4_radio = new JRadioButton();
      portB_valve5_radio = new JRadioButton();
      portB_valve6_radio = new JRadioButton();
      portB_valve7_radio = new JRadioButton();
      portB_valve8_radio = new JRadioButton();

      portC_valve1_radio = new JRadioButton();
      portC_valve2_radio = new JRadioButton();
      portC_valve3_radio = new JRadioButton();
      portC_valve4_radio = new JRadioButton();
      portC_valve5_radio = new JRadioButton();
      portC_valve6_radio = new JRadioButton();
      portC_valve7_radio = new JRadioButton();
      portC_valve8_radio = new JRadioButton();

      valve_radio_list.add(portA_valve1_radio);
      valve_radio_list.add(portA_valve2_radio);
      valve_radio_list.add(portA_valve3_radio);
      valve_radio_list.add(portA_valve4_radio);
      valve_radio_list.add(portA_valve5_radio);
      valve_radio_list.add(portA_valve6_radio);
      valve_radio_list.add(portA_valve7_radio);
      valve_radio_list.add(portA_valve8_radio);
      valve_radio_list.add(portB_valve1_radio);
      valve_radio_list.add(portB_valve2_radio);
      valve_radio_list.add(portB_valve3_radio);
      valve_radio_list.add(portB_valve4_radio);
      valve_radio_list.add(portB_valve5_radio);
      valve_radio_list.add(portB_valve6_radio);
      valve_radio_list.add(portB_valve7_radio);
      valve_radio_list.add(portB_valve8_radio);
      valve_radio_list.add(portC_valve1_radio);
      valve_radio_list.add(portC_valve2_radio);
      valve_radio_list.add(portC_valve3_radio);
      valve_radio_list.add(portC_valve4_radio);
      valve_radio_list.add(portC_valve5_radio);
      valve_radio_list.add(portC_valve6_radio);
      valve_radio_list.add(portC_valve7_radio);
      valve_radio_list.add(portC_valve8_radio);

      for(int i=0; i<3; i++){
        JLabel reversing_pattern_label = new JLabel();
        reversing_pattern_label.setBounds(30, 0, 200, 50);
        reversing_pattern_label.setText("valve reversing pattern");
        if(i == 0){
          portA_tab.add(reversing_pattern_label);
        }else if(i == 1){
          portB_tab.add(reversing_pattern_label);	
        }else{
          portC_tab.add(reversing_pattern_label);
        }
      }

      for(int i=0; i<scroll_list.size(); i++){
        scroll_list.get(i).setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scroll_list.get(i).setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        JLabel label = new JLabel();
        if(i < 8){
          label.setText("valve "+(i+1));
          label.setBounds(55+120*i, 20, 100, 50);
          scroll_list.get(i).setBounds(30+120*i, 60, 100, 50);
          portA_tab.add(label);
          portA_tab.add(scroll_list.get(i));
        }else if(i < 16){
          label.setText("valve "+(i-8+1));
          label.setBounds(55+120*(i-8), 20, 100, 50);
          scroll_list.get(i).setBounds(30+120*(i-8), 60, 100, 50);
          portB_tab.add(label);
          portB_tab.add(scroll_list.get(i));
        }else{
          label.setText("valve "+(i-16+1));
          label.setBounds(55+120*(i-16), 20, 100, 50);
          scroll_list.get(i).setBounds(30+120*(i-16), 60, 100, 50);
          portC_tab.add(label);
          portC_tab.add(scroll_list.get(i));
        }
      }

      for(int i=0; i<3; i++){
        JLabel initial_state_label = new JLabel();
        initial_state_label.setBounds(30, 120, 200, 50);
        initial_state_label.setText("valve initial state");
        if(i == 0){
          portA_tab.add(initial_state_label);	
        }else if(i == 1){
          portB_tab.add(initial_state_label);	
        }else{
          portC_tab.add(initial_state_label);	
        }
      }

      for(int i=0; i<valve_radio_list.size(); i++){
        JLabel label = new JLabel();
        valve_radio_list.get(i).addChangeListener(new repaintByRadioButton());
        if(i < 8){
          label.setText("valve "+(i+1));
          label.setBounds(55+120*i, 140, 100, 50);
          valve_radio_list.get(i).setBounds(65+120*i, 180, 30, 30);
          portA_tab.add(label);
          portA_tab.add(valve_radio_list.get(i));
        }else if(i < 16){
          label.setText("valve "+(i-8+1));
          label.setBounds(55+120*(i-8), 140, 100, 50);
          valve_radio_list.get(i).setBounds(65+120*(i-8), 180, 30, 30);
          portB_tab.add(label);
          portB_tab.add(valve_radio_list.get(i));
        }else{
          label.setText("valve "+(i-16+1));
          label.setBounds(55+120*(i-16), 140, 100, 50);
          valve_radio_list.get(i).setBounds(65+120*(i-16), 180, 30, 30);
          portC_tab.add(label);
          portC_tab.add(valve_radio_list.get(i));
        }
      }

      for(int i=0; i<3; i++){
        finish_button = new JButton("Finish");
        finish_button.addActionListener(new myFinishAction());
        finish_button.addMouseListener(new rewriteControllingTime());
        finish_button.setBounds(870, 230, 100, 30);
        if(i == 0){
          portA_tab.add(finish_button);
        }else if(i == 1){
          portB_tab.add(finish_button);
        }else{
          portC_tab.add(finish_button);
        }
      }

      for(int i=0; i<3; i++){
        all_clear_button = new JButton("All Claer");
        all_clear_button.addActionListener(new myAllClearAction());
        all_clear_button.setBounds(750, 230, 100, 30);
        if(i == 0){
          portA_tab.add(all_clear_button);
        }else if(i == 1){
          portB_tab.add(all_clear_button);
        }else{
          portC_tab.add(all_clear_button);
        }
      }

      controlling_time_fieldA = new JTextField();
      controlling_time_fieldA.setEditable(true);
      controlling_time_fieldA.setBounds(150, 230, 200, 30);
      controlling_time_fieldA.addActionListener(new mySync());
      controlling_time_fieldA.addMouseListener(new rewriteControllingTime());
      controlling_time_fieldB = new JTextField();
      controlling_time_fieldB.setEditable(true);
      controlling_time_fieldB.setBounds(150, 230, 200, 30);
      controlling_time_fieldB.addActionListener(new mySync());
      controlling_time_fieldB.addMouseListener(new rewriteControllingTime());
      controlling_time_fieldC = new JTextField();
      controlling_time_fieldC.setEditable(true);
      controlling_time_fieldC.setBounds(150, 230, 200, 30);
      controlling_time_fieldC.addActionListener(new mySync());
      controlling_time_fieldC.addMouseListener(new rewriteControllingTime());
      for(int i=0; i<3; i++){
        JLabel controlling_time_label = new JLabel();
        controlling_time_label.setText("Controlling Time");
        controlling_time_label.setBounds(30, 230, 120, 30);
        if(i == 0){
          portA_tab.add(controlling_time_label);
          portA_tab.add(controlling_time_fieldA);
        }else if(i == 1){
          portB_tab.add(controlling_time_label);
          portB_tab.add(controlling_time_fieldB);
        }else{
          portC_tab.add(controlling_time_label);
          portC_tab.add(controlling_time_fieldC);
        }
      }

      //file loding
      BufferedReader br1;
      BufferedReader br2;
      BufferedReader br3;
      try {
        String line, imp, value, order;
        // br1 = new BufferedReader(new FileReader(current_dir+"/valve_controller_program/myControlProg/valve_reversing_pattern.config"));
        br1 = new BufferedReader(new FileReader(config_dir+"valve_reversing_pattern.config"));
        while((line=br1.readLine()) != null){
          imp = line.split(" = ")[1];
          value = imp.split("; //")[0];
          order = imp.split("; //")[1];
          valve_ta_list.get(Integer.parseInt(order)).setText(valve_ta_list.get(Integer.parseInt(order)).getText()+value+"\n");
        }
        br1.close();
        char char_val;
        // br2 = new BufferedReader(new FileReader(current_dir+"/valve_controller_program/myControlProg/valve_initial_state.config"));
        br2 = new BufferedReader(new FileReader(config_dir+"valve_initial_state.config"));
        while((line=br2.readLine()) != null){
          value = line.split(" = ")[1].replaceAll(";", "");
          char_val = (char)Integer.parseInt(value);
          if(line.split(" = ")[0].equals("valveA_state")){
            for(int i=0; i<8; i++){
              if((char_val & (1 << (char)i)) != 0){
                valve_radio_list.get(i).setSelected(true);
              }else{
                valve_radio_list.get(i).setSelected(false);
              }
            }
          }else if(line.split(" = ")[0].equals("valveB_state")){
            for(int i=8; i<16; i++){
              if((char_val & (1 << (char)(i-8))) != 0){
                valve_radio_list.get(i).setSelected(true);
              }else{
                valve_radio_list.get(i).setSelected(false);
              }
            }
          }else if(line.split(" = ")[0].equals("valveC_state")){
            for(int i=16; i<24; i++){
              if((char_val & (1 << (char)(i-16))) != 0){
                valve_radio_list.get(i).setSelected(true);
              }else{
                valve_radio_list.get(i).setSelected(false);
              }
            }
          }
        }
        br2.close();
        // br3 = new BufferedReader(new FileReader(current_dir+"/valve_controller_program/myControlProg/controlling_time.config"));
        br3 = new BufferedReader(new FileReader(config_dir+"controlling_time.config"));
        while((line=br3.readLine()) != null){
          value = line.split(" = ")[1].replaceAll(";", "");
          controlling_time_fieldA.setText(value);
          controlling_time_fieldB.setText(value);
          controlling_time_fieldC.setText(value);
        }
        br3.close();
      } catch (Exception e1) {
        // TODO Auto-generated catch block
        e1.printStackTrace();
      }

      valve_ta_list_init = new ArrayList<JTextArea>();
      valve_radio_list_init = new ArrayList<JRadioButton>();

      for(int i=0; i<24; i++){
        valve_ta_list_init.add(new JTextArea(valve_ta_list.get(i).getText()));
        valve_radio_list_init.add(new JRadioButton());
        valve_radio_list_init.get(i).setSelected(valve_radio_list.get(i).isSelected());
      }
      controlling_time_field_init = new JTextField();
      controlling_time_field_init.setText(controlling_time_fieldA.getText());

      for(int i=0; i<3; i++){
        initialize_button = new JButton("Initialize");
        initialize_button.addActionListener(new myInitializeAction());
        initialize_button.setBounds(630, 230, 100, 30);
        if(i == 0){
          portA_tab.add(initialize_button);
        }else if(i == 1){
          portB_tab.add(initialize_button);
        }else{
          portC_tab.add(initialize_button);
        }
      }

      for(int i=0; i<3; i++){
        visualize_button = new JButton("Visualize");
        visualize_button.addActionListener(new myVisualizeAction());
        visualize_button.addMouseListener(new rewriteControllingTime());
        visualize_button.setBounds(510, 230, 100, 30);
        if(i == 0){
          portA_tab.add(visualize_button);
        }else if(i == 1){
          portB_tab.add(visualize_button);
        }else{
          portC_tab.add(visualize_button);
        }
      }

    }
  }

  private class myFinishAction implements ActionListener{
    public void actionPerformed(ActionEvent e) {
      int option = JOptionPane.showConfirmDialog(main_frame, "Do you want to write this controll pattern to config files?");
      if (option == JOptionPane.CANCEL_OPTION){
        return;
      } else if (option == JOptionPane.YES_OPTION){
        PrintWriter pw1;
        PrintWriter pw2;
        PrintWriter pw3;
        try {
          pw1 = new PrintWriter(new BufferedWriter(new FileWriter(config_dir+"valve_reversing_pattern.config")));
          for(int i=0; i<valve_ta_list.size(); i++){
            String row_string[] = valve_ta_list.get(i).getText().split("\n");
            for(int j=0; j<row_string.length; j++){
              if(!row_string[j].equals("")){
                pw1.print("valve_param["
                    +i+"]->reversing_times[(valve_param["
                    +i+"]->num_of_reversing_times)++] = "
                    +row_string[j]+"; //"+i+"\n");
              }
            }
          }
          pw1.close();
          pw2 = new PrintWriter(new BufferedWriter(new FileWriter(config_dir+"valve_initial_state.config")));
          int valve_state = 0;
          for(int i=0; i<valve_radio_list.size(); i++){
            if(valve_radio_list.get(i).isSelected()){
              if(i < 8){
                valve_state += (1 << i);
              }else if(i < 16){
                valve_state += (1 << (i-8));
              }else{
                valve_state += (1 << (i-16));
              }
            }
            if(i == 7){
              pw2.print("valveA_state = "+valve_state+";\n");
              valve_state = 0;
            }else if(i == 15){
              pw2.print("valveB_state = "+valve_state+";\n");
              valve_state = 0;
            }else if(i == 23){
              pw2.print("valveC_state = "+valve_state+";\n");
            }
          }
          pw2.close();
          pw3 = new PrintWriter(new BufferedWriter(new FileWriter(config_dir+"controlling_time.config")));
          pw3.print("controlling_time = "+controlling_time_fieldA.getText()+";\n");
          pw3.close();
        } catch (Exception e2) {
          e2.printStackTrace();
        }
        JOptionPane.showMessageDialog(main_frame, "Please go to\n" + config_dir + "\non your terminal and then type \"make\".");
      }
      main_frame.dispose();
      System.exit(0);
    }
  }

  private class myAllClearAction implements ActionListener{

    public void actionPerformed(ActionEvent e) {
      // TODO Auto-generated method stub
      for(int i=0; i<24; i++){
        valve_ta_list.get(i).setText("");
        valve_radio_list.get(i).setSelected(false);
      }
      controlling_time_fieldA.setText("0");
      controlling_time_fieldB.setText("0");
      controlling_time_fieldC.setText("0");
    }
  }

  private class myInitializeAction implements ActionListener{

    public void actionPerformed(ActionEvent e) {
      // TODO Auto-generated method stub
      for(int i=0; i<24; i++){
        valve_ta_list.get(i).setText(valve_ta_list_init.get(i).getText());
        valve_radio_list.get(i).setSelected(valve_radio_list_init.get(i).isSelected());
      }
      controlling_time_fieldA.setText(controlling_time_field_init.getText());
      controlling_time_fieldB.setText(controlling_time_field_init.getText());
      controlling_time_fieldC.setText(controlling_time_field_init.getText());
    }
  }

  private class repaintByRadioButton implements ChangeListener{

    public void stateChanged(ChangeEvent e) {
      // TODO Auto-generated method stub
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

  }

  private class repaintByTextArea implements KeyListener{

    public void keyPressed(KeyEvent e) {
      // TODO Auto-generated method stub
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

    public void keyReleased(KeyEvent e) {
      // TODO Auto-generated method stub
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

    public void keyTyped(KeyEvent e) {
      // TODO Auto-generated method stub
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

  }

  private class rewriteControllingTime implements MouseListener{

    public void mouseClicked(MouseEvent e) {
      // TODO Auto-generated method stub
      double max_time = 0;
      for(int i=0; i<valve_ta_list.size(); i++){
        String temp_string[] = valve_ta_list.get(i).getText().split("\n");
        if(temp_string.length != 0
            && !temp_string[0].equals("") 
            && Double.parseDouble(temp_string[temp_string.length-1]) > max_time){
          max_time = Double.parseDouble(temp_string[temp_string.length-1]);
            }
      }
      if(controlling_time_fieldA.getText().equals("") || (!controlling_time_fieldA.getText().equals("") && Double.parseDouble(controlling_time_fieldA.getText()) < max_time)){
        controlling_time_fieldA.setText(Double.toString(max_time));
        controlling_time_fieldB.setText(Double.toString(max_time));
        controlling_time_fieldC.setText(Double.toString(max_time));
      }else if(e.getSource() == controlling_time_fieldA){
        controlling_time_fieldB.setText(controlling_time_fieldA.getText());
        controlling_time_fieldC.setText(controlling_time_fieldA.getText());
      }else if(e.getSource() == controlling_time_fieldB){
        controlling_time_fieldA.setText(controlling_time_fieldB.getText());
        controlling_time_fieldC.setText(controlling_time_fieldB.getText());				
      }else if(e.getSource() == controlling_time_fieldC){
        controlling_time_fieldA.setText(controlling_time_fieldC.getText());
        controlling_time_fieldB.setText(controlling_time_fieldC.getText());				
      }
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

    public void mouseEntered(MouseEvent e) {
      // TODO Auto-generated method stub
      double max_time = 0;
      for(int i=0; i<valve_ta_list.size(); i++){
        String temp_string[] = valve_ta_list.get(i).getText().split("\n");
        if(temp_string.length != 0
            && !temp_string[0].equals("") 
            && Double.parseDouble(temp_string[temp_string.length-1]) > max_time){
          max_time = Double.parseDouble(temp_string[temp_string.length-1]);
            }
      }
      if(controlling_time_fieldA.getText().equals("") || (!controlling_time_fieldA.getText().equals("") && Double.parseDouble(controlling_time_fieldA.getText()) < max_time)){
        controlling_time_fieldA.setText(Double.toString(max_time));
        controlling_time_fieldB.setText(Double.toString(max_time));
        controlling_time_fieldC.setText(Double.toString(max_time));
      }else if(e.getSource() == controlling_time_fieldA){
        controlling_time_fieldB.setText(controlling_time_fieldA.getText());
        controlling_time_fieldC.setText(controlling_time_fieldA.getText());
      }else if(e.getSource() == controlling_time_fieldB){
        controlling_time_fieldA.setText(controlling_time_fieldB.getText());
        controlling_time_fieldC.setText(controlling_time_fieldB.getText());				
      }else if(e.getSource() == controlling_time_fieldC){
        controlling_time_fieldA.setText(controlling_time_fieldC.getText());
        controlling_time_fieldB.setText(controlling_time_fieldC.getText());				
      }
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

    public void mouseExited(MouseEvent e) {
      // TODO Auto-generated method stub
      double max_time = 0;
      for(int i=0; i<valve_ta_list.size(); i++){
        String temp_string[] = valve_ta_list.get(i).getText().split("\n");
        if(temp_string.length != 0
            && !temp_string[0].equals("") 
            && Double.parseDouble(temp_string[temp_string.length-1]) > max_time){
          max_time = Double.parseDouble(temp_string[temp_string.length-1]);
            }
      }
      if(controlling_time_fieldA.getText().equals("") || (!controlling_time_fieldA.getText().equals("") && Double.parseDouble(controlling_time_fieldA.getText()) < max_time)){
        controlling_time_fieldA.setText(Double.toString(max_time));
        controlling_time_fieldB.setText(Double.toString(max_time));
        controlling_time_fieldC.setText(Double.toString(max_time));
      }else if(e.getSource() == controlling_time_fieldA){
        controlling_time_fieldB.setText(controlling_time_fieldA.getText());
        controlling_time_fieldC.setText(controlling_time_fieldA.getText());
      }else if(e.getSource() == controlling_time_fieldB){
        controlling_time_fieldA.setText(controlling_time_fieldB.getText());
        controlling_time_fieldC.setText(controlling_time_fieldB.getText());				
      }else if(e.getSource() == controlling_time_fieldC){
        controlling_time_fieldA.setText(controlling_time_fieldC.getText());
        controlling_time_fieldB.setText(controlling_time_fieldC.getText());				
      }
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

    public void mousePressed(MouseEvent e) {
      // TODO Auto-generated method stub
      double max_time = 0;
      for(int i=0; i<valve_ta_list.size(); i++){
        String temp_string[] = valve_ta_list.get(i).getText().split("\n");
        if(temp_string.length != 0
            && !temp_string[0].equals("") 
            && Double.parseDouble(temp_string[temp_string.length-1]) > max_time){
          max_time = Double.parseDouble(temp_string[temp_string.length-1]);
            }
      }
      if(controlling_time_fieldA.getText().equals("") || (!controlling_time_fieldA.getText().equals("") && Double.parseDouble(controlling_time_fieldA.getText()) < max_time)){
        controlling_time_fieldA.setText(Double.toString(max_time));
        controlling_time_fieldB.setText(Double.toString(max_time));
        controlling_time_fieldC.setText(Double.toString(max_time));
      }else if(e.getSource() == controlling_time_fieldA){
        controlling_time_fieldB.setText(controlling_time_fieldA.getText());
        controlling_time_fieldC.setText(controlling_time_fieldA.getText());
      }else if(e.getSource() == controlling_time_fieldB){
        controlling_time_fieldA.setText(controlling_time_fieldB.getText());
        controlling_time_fieldC.setText(controlling_time_fieldB.getText());				
      }else if(e.getSource() == controlling_time_fieldC){
        controlling_time_fieldA.setText(controlling_time_fieldC.getText());
        controlling_time_fieldB.setText(controlling_time_fieldC.getText());				
      }
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

    public void mouseReleased(MouseEvent e) {
      // TODO Auto-generated method stub
      double max_time = 0;
      for(int i=0; i<valve_ta_list.size(); i++){
        String temp_string[] = valve_ta_list.get(i).getText().split("\n");
        if(temp_string.length != 0
            && !temp_string[0].equals("") 
            && Double.parseDouble(temp_string[temp_string.length-1]) > max_time){
          max_time = Double.parseDouble(temp_string[temp_string.length-1]);
            }
      }
      if(controlling_time_fieldA.getText().equals("") || (!controlling_time_fieldA.getText().equals("") && Double.parseDouble(controlling_time_fieldA.getText()) < max_time)){
        controlling_time_fieldA.setText(Double.toString(max_time));
        controlling_time_fieldB.setText(Double.toString(max_time));
        controlling_time_fieldC.setText(Double.toString(max_time));
      }else if(e.getSource() == controlling_time_fieldA){
        controlling_time_fieldB.setText(controlling_time_fieldA.getText());
        controlling_time_fieldC.setText(controlling_time_fieldA.getText());
      }else if(e.getSource() == controlling_time_fieldB){
        controlling_time_fieldA.setText(controlling_time_fieldB.getText());
        controlling_time_fieldC.setText(controlling_time_fieldB.getText());				
      }else if(e.getSource() == controlling_time_fieldC){
        controlling_time_fieldA.setText(controlling_time_fieldC.getText());
        controlling_time_fieldB.setText(controlling_time_fieldC.getText());				
      }
      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }
    }

  }

  private class mySync implements ActionListener{

    public void actionPerformed(ActionEvent e) {
      // TODO Auto-generated method stub
      double max_time = 0;
      for(int i=0; i<valve_ta_list.size(); i++){
        String temp_string[] = valve_ta_list.get(i).getText().split("\n");
        if(temp_string.length != 0
            && !temp_string[0].equals("") 
            && Double.parseDouble(temp_string[temp_string.length-1]) > max_time){
          max_time = Double.parseDouble(temp_string[temp_string.length-1]);
            }
      }

      if(e.getSource() == controlling_time_fieldA){
        if(!controlling_time_fieldA.getText().equals("") && Double.parseDouble(controlling_time_fieldA.getText()) >= max_time){
          controlling_time_fieldB.setText(controlling_time_fieldA.getText());
          controlling_time_fieldC.setText(controlling_time_fieldA.getText());
        }else{
          controlling_time_fieldA.setText(Double.toString(max_time));
          controlling_time_fieldB.setText(Double.toString(max_time));
          controlling_time_fieldC.setText(Double.toString(max_time));
        }
      }else if(e.getSource() == controlling_time_fieldB){
        if(!controlling_time_fieldB.getText().equals("") && Double.parseDouble(controlling_time_fieldB.getText()) >= max_time){
          controlling_time_fieldA.setText(controlling_time_fieldB.getText());
          controlling_time_fieldC.setText(controlling_time_fieldB.getText());
        }else{
          controlling_time_fieldA.setText(Double.toString(max_time));
          controlling_time_fieldB.setText(Double.toString(max_time));
          controlling_time_fieldC.setText(Double.toString(max_time));
        }
      }else if(e.getSource() == controlling_time_fieldC){
        if(!controlling_time_fieldC.getText().equals("") && Double.parseDouble(controlling_time_fieldB.getText()) >= max_time){
          controlling_time_fieldA.setText(controlling_time_fieldC.getText());
          controlling_time_fieldB.setText(controlling_time_fieldC.getText());
        }else{
          controlling_time_fieldA.setText(Double.toString(max_time));
          controlling_time_fieldB.setText(Double.toString(max_time));
          controlling_time_fieldC.setText(Double.toString(max_time));
        }
      }

      for(int i=0; i<sub_frame_list.size(); i++){
        sub_frame_list.get(i).getDrawPanel().repaint();
      }

    }

  }

  private class myVisualizeAction implements ActionListener{

    public void actionPerformed(ActionEvent e) {
      sub_frame_list.add(new visualizeFrame());
    }

  }

  private class visualizeFrame extends JFrame{

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private int selected_order;
    private JComboBox comboBox = null;
    private DrawPanel drawPanel = null;

    visualizeFrame(){
      super("Visualizing Valve Reversing Pattern");
      this.setBounds(main_frame.getX(), main_frame.getY()+main_frame.getHeight(), 1000, 200);
      this.setResizable(false);
      this.setDefaultCloseOperation(HIDE_ON_CLOSE);
      this.addWindowListener(new WindowListener(){

        public void windowActivated(WindowEvent e) {
          // TODO Auto-generated method stub

        }

        public void windowClosed(WindowEvent e) {
          // TODO Auto-generated method stub
          sub_frame_list.remove(this);
        }

        public void windowClosing(WindowEvent e) {
          // TODO Auto-generated method stub

        }

        public void windowDeactivated(WindowEvent e) {
          // TODO Auto-generated method stub

        }

        public void windowDeiconified(WindowEvent e) {
          // TODO Auto-generated method stub

        }

        public void windowIconified(WindowEvent e) {
          // TODO Auto-generated method stub

        }

        public void windowOpened(WindowEvent e) {
          // TODO Auto-generated method stub

        }

      });
      this.setLayout(null);

      comboBox = new JComboBox();
      for(int i=0; i<24; i++){
        if(i < 8){
          comboBox.addItem("Valve "+(i+1)+" of Port A");
        }else if(i < 16){
          comboBox.addItem("Valve "+(i-8+1)+" of Port B");
        }else{
          comboBox.addItem("Valve "+(i-16+1)+" of Port C");
        }
      }
      comboBox.setBounds(0, 0, 300, 50);
      comboBox.addItemListener(new myItemListener());
      selected_order = comboBox.getSelectedIndex();
      this.add(comboBox);

      drawPanel = new DrawPanel();
      drawPanel.setBounds(0, 50, 1000, 150);
      this.add(drawPanel, BorderLayout.CENTER);

      this.setVisible(true);
    }

    public JPanel getDrawPanel(){
      return this.drawPanel;
    }

    private class myItemListener implements ItemListener{

      public void itemStateChanged(ItemEvent e) {
        // TODO Auto-generated method stub
        selected_order = comboBox.getSelectedIndex();
        drawPanel.repaint();
      }

    }

    private class DrawPanel extends JPanel{

      /**
       * 
       */
      private static final long serialVersionUID = 1L;

      DrawPanel(){
        super();
        this.setSize(1000, 150);
      }


      public void paint(Graphics g){
        int whole_line_length = 900;
        int offset = 50;
        int start_point , end_point;
        double max_time, time, pre_time;
        int on_off; //on 1, off -1
        int on_y = 30;
        int off_y = 80;
        if(valve_radio_list.get(selected_order).isSelected()){
          on_off = 1;
        }else{
          on_off = -1;
        }
        String valve_reversing_time_points[] = valve_ta_list.get(selected_order).getText().split("\n");
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g.fillRect(offset, on_y-10, whole_line_length, off_y-on_y+10);
        g.setColor(Color.black);
        g.drawString("ON", 10, on_y);
        g.drawString("OFF", 10, off_y);
        g.setColor(Color.red);
        start_point = offset;
        max_time = Double.parseDouble(controlling_time_fieldA.getText());
        g.setColor(Color.black);
        g.drawString("0", offset, off_y+20);
        g.setColor(Color.red);
        if(!valve_reversing_time_points[0].equals("")){
          for(int i=0; i<valve_reversing_time_points.length; i++){
            time = Double.parseDouble(valve_reversing_time_points[i]);
            if(i!=0){
              pre_time = Double.parseDouble(valve_reversing_time_points[i-1]);
            }else{
              pre_time = 0;
            }
            end_point = start_point+(int)((time-pre_time)/max_time*(double)whole_line_length);
            if(on_off == 1){
              g.drawLine(start_point, on_y, end_point, on_y); //horizontal
              g.drawLine(end_point, on_y, end_point, off_y); //vertical
            }else{
              g.drawLine(start_point, off_y, end_point, off_y); //horizontal
              g.drawLine(end_point, off_y, end_point, on_y); //vertical
            }
            g.setColor(Color.black);
            g.drawString(Double.toString(time), end_point, off_y+20);
            g.setColor(Color.red);
            on_off *= -1;
            start_point = end_point;
          }
          if(Double.parseDouble(valve_reversing_time_points[valve_reversing_time_points.length-1]) != max_time){
            if(on_off == 1){
              g.drawLine(start_point, on_y, offset+whole_line_length, on_y);
            }else{
              g.drawLine(start_point, off_y, offset+whole_line_length, off_y);
            }
            g.setColor(Color.black);
            g.drawString(Double.toString(max_time), offset+whole_line_length, off_y+20);
            g.setColor(Color.red);
          }
        }else{
          if(on_off == 1){
            g.drawLine(start_point, on_y, start_point+whole_line_length, on_y);
          }else{
            g.drawLine(start_point, off_y, start_point+whole_line_length, off_y);
          }
          g.setColor(Color.black);
          g.drawString(Double.toString(max_time), offset+whole_line_length, off_y+20);
          g.setColor(Color.red);
        }
      }

    }

  }

}

