#ifndef __FUNADEVICE_H__
#define __FUNADEVICE_H__

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include "ftd2xx.h"

#define BUF_SIZE 16
#define MAX_STRING_SIZE 64

typedef struct myDevice {
	FT_HANDLE ftHandle;
	char serial[MAX_STRING_SIZE];
	DWORD vid;
	DWORD pid;
} myDevice_t;

extern myDevice_t *globalDev;
extern int isDebug;

/* Low level API */
void closeDevice(myDevice_t *pDev);
int openDevice(myDevice_t *pDev);
DWORD readDevice(myDevice_t *pDev, char *readBuffer, DWORD dwRxSize);
DWORD writeDevice(myDevice_t *pDev, unsigned char *writeBuffer, int size);
void resetDevice(myDevice_t *pDev);
void purgeDevice(myDevice_t *pDev);
void quit();

/* High level API */
int setOutputMode(myDevice_t *pDev);
int setInputMode(myDevice_t *pDev);
int identifyDevice(myDevice_t *pDev);
int writeAllPort(myDevice_t *pDev, unsigned char valA, unsigned char valB, unsigned char valC);
int writeBinaryAllPort(myDevice_t *pDev, char* strA, char* strB, char* strC);
int writePort(myDevice_t *pDev, unsigned char port, unsigned char val);
int writePortA(myDevice_t *pDev, unsigned char val);
int writePortB(myDevice_t *pDev, unsigned char val);
int writePortC(myDevice_t *pDev, unsigned char val);
int writeBinaryPortA(myDevice_t *pDev, char* str);
int writeBinaryPortB(myDevice_t *pDev, char* str);
int writeBinaryPortC(myDevice_t *pDev, char* str);
void closeAllValves(myDevice_t *pDev);
void closePortA(myDevice_t *pDev);
void closePortB(myDevice_t *pDev);
void closePortC(myDevice_t *pDev);
void openAllValves(myDevice_t *pDev);
void openPortA(myDevice_t *pDev);
void openPortB(myDevice_t *pDev);
void openPortC(myDevice_t *pDev);

#endif  /* __FUNADEVICE_H__ */
