/**
 * 
 */

import static com.googlecode.javacv.cpp.opencv_highgui.cvCreateCameraCapture;
import ij.*;
import ij.gui.ImageWindow;
import ij.plugin.*;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

import java.awt.image.BufferedImage;

import com.googlecode.javacv.FrameGrabber.Exception;
import com.googlecode.javacv.OpenCVFrameGrabber;
import com.googlecode.javacv.cpp.opencv_core.IplImage;

/**
 * @author Akira Funahashi
 * @author Yuki Tsukada
 * 
 */
public class ISight_Capture implements PlugIn {
	static boolean isRunning = false;
	String title = "iSight Capture";
	OpenCVFrameGrabber grabber;

	public void run(String arg) {
		if (arg.equals("about")) {
			showAbout();
			return;
		} else if (arg.equals("test")) {
			if (isRunning) {
				testSequentiallyCapture();
			} else {
				IJ.error("Please launch iSight Capture plugin before you call this Test plugin");
			}
			return;
		}

		if (!isRunning) {
			IJ.showStatus("iSight Capture plugin started.");
			for (int i = 5; i >= 0; i--) {
				if (cvCreateCameraCapture(i) != null) {
					int num_device = i+1;
					if (i > 0) {
						IJ.log("Found " + num_device + " devices.");
					}
					break;
				}
			}
			int device = 0;
			grabber = new OpenCVFrameGrabber(device);
			IJ.log("Open Device = " + device);
			setResolution(arg);
			try {
				grabber.start();
				isRunning = true;
				IplImage frame = grabber.grab();
				ImagePlus imp = null;
				ImageWindow iw = null;
				ImageProcessor ip = new ColorProcessor(grabber.getImageWidth(),	grabber.getImageHeight());
				imp = new ImagePlus(title, ip);
				imp.show();
				iw = imp.getWindow();
				while ((frame = grabber.grab()) != null) {
					BufferedImage im;
					if (IJ.escapePressed() || IJ.spaceBarDown()) {
						break;
					}
					if (iw.isVisible()) {
						im = frame.getBufferedImage();
						imp.setImage(im);
						imp.updateAndDraw();
					} else {
						break;
					}
				}
				grabber.stop();
				isRunning = false;
			} catch (Exception e) {
				e.printStackTrace();
			}
			IJ.showStatus("iSight plugin stopped.");
		} else {
			IJ.error("You can not launch multiple instances of this plugin at the same time.");
		}
	}

	private void setResolution(String arg) {
		if (arg.equals("qvga")) { // 320x240
			grabber.setImageWidth(320);
			grabber.setImageHeight(240);
		} else if (arg.equals("vga")) { // 640x480
			grabber.setImageWidth(640);
			grabber.setImageHeight(480);
		} else if (arg.equals("svga")) { // 800x600
			grabber.setImageWidth(800);
			grabber.setImageHeight(600);
		} else if (arg.equals("xga")) { // 1024x768
			grabber.setImageWidth(1024);
			grabber.setImageHeight(768);
		} else if (arg.equals("hd")) { // 1366×768
			grabber.setImageWidth(1366);
			grabber.setImageHeight(768);
		} else if (arg.equals("sxga")) { // 1280×1024
			grabber.setImageWidth(1280);
			grabber.setImageHeight(1024);
		} else if (arg.equals("uxga")) { // 1600×1200
			grabber.setImageWidth(1600);
			grabber.setImageHeight(1200);
		} else if (arg.equals("fhd")) { // 1920×1080
			grabber.setImageWidth(1920);
			grabber.setImageHeight(1080);
		} else if (arg.equals("wuxga")) { // 1920×1200
			grabber.setImageWidth(1920);
			grabber.setImageHeight(1200);
		}
	}

	public void testSequentiallyCapture() {
		for (int i = 0; i < 5; i++) {
			IJ.selectWindow(title);
			IJ.run("Duplicate...", "title=Capture" + i);
		}
	}

	public void showAbout() {
		IJ.showMessage("iSight Capture",
				"This plugin is just a demonstration for iSight and ImageJ.\n"
						+ "Implemented by Akira Funahashi and Yuki Tsukada");
	}
}
